/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.model;

import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter;
import org2.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org2.eclipse.php.internal.debug.core.zend.model.PHPVariable;

public class WatchExpressionFactoryAdapter
implements IWatchExpressionFactoryAdapter {
    private static final String TYPE_ARRAY = "ARRAY";
    private static final String TYPE_OBJECT = "OBJECT";

    public String createWatchExpression(IVariable variable) throws CoreException {
        Stack<IVariable> stack;
        PHPDebugTarget debugTarget;
        IVariable[] variables;
        PHPVariable phpVar;
        if (variable instanceof PHPVariable && this.findVariable(phpVar = (PHPVariable)variable, variables = (debugTarget = (PHPDebugTarget)phpVar.getDebugTarget()).getVariables(null), stack = new Stack<IVariable>())) {
            return this.createExpression(stack);
        }
        return variable.getName();
    }

    private boolean findVariable(PHPVariable phpVar, IVariable[] variables, Stack<IVariable> stack) throws DebugException {
        IVariable[] iVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable[] vars;
            IVariable variable = iVariableArray[n2];
            if (variable.equals((Object)phpVar)) {
                stack.push(variable);
                return true;
            }
            IValue value = variable.getValue();
            if (value.hasVariables() && this.findVariable(phpVar, vars = value.getVariables(), stack)) {
                stack.push(variable);
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String createExpression(Stack<IVariable> stack) throws DebugException {
        StringBuffer expr = new StringBuffer();
        String parentType = "";
        while (!stack.isEmpty()) {
            IVariable variable = stack.pop();
            String name = variable.getName();
            if (parentType.equals(TYPE_ARRAY)) {
                expr.append("['").append(name).append("']");
            } else if (parentType.equals(TYPE_OBJECT)) {
                expr.append("->").append(name);
            } else {
                expr.append(name);
            }
            parentType = variable.getReferenceTypeName();
        }
        return expr.toString();
    }
}

